<?php
/**
 * Blog Layouts customizer settings.
 *
 * @package Page Builder Framework Premium Add-On
 * @subpackage Customizer
 */

defined( 'ABSPATH' ) || die( "Can't access directly" );

/* Archive Layouts - Fields */

$archives = apply_filters( 'wpbf_archives', array( 'archive' ) );

foreach ( $archives as $archive ) {

	// Headline.
	new \Kirki\Pro\Field\Headline(
		[
			'settings'        => $archive . '_grid_layout_headline',
			'label'           => esc_html__( 'Grid Layout Settings', 'wpbfpremium' ),
			'section'         => 'wpbf_' . $archive . '_options',
			'priority'        => 100,
			'active_callback' => [
				[
					'setting'  => $archive . '_layout',
					'operator' => '==',
					'value'    => 'grid',
				],
			],
		]
	);

	// Grid.
	Kirki::add_field( 'wpbf', array(
		'type'              => 'responsive_input',
		'settings'          => $archive . '_grid',
		'label'             => __( 'Posts per Row', 'wpbfpremium' ),
		'section'           => 'wpbf_' . $archive . '_options',
		'priority'          => 110,
		'default'           => json_encode(
			array(
				'desktop' => '3',
				'tablet'  => '2',
				'mobile'  => '1',
			)
		),
		'active_callback'   => array(
			array(
				'setting'  => $archive . '_layout',
				'operator' => '==',
				'value'    => 'grid',
			),
		),
		'sanitize_callback' => wpbf_kirki_sanitize_helper( 'absint' ),
	) );

	// Gap.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'select',
		'settings'        => $archive . '_grid_gap',
		'label'           => __( 'Grid Gap', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $archive . '_options',
		'default'         => 'small',
		'priority'        => 120,
		'multiple'        => 1,
		'choices'         => array(
			'small'    => __( 'Small', 'wpbfpremium' ),
			'medium'   => __( 'Medium', 'wpbfpremium' ),
			'large'    => __( 'Large', 'wpbfpremium' ),
			'xlarge'   => __( 'xLarge', 'wpbfpremium' ),
			'collapse' => __( 'Collapse', 'wpbfpremium' ),
		),
		'active_callback' => array(
			array(
				'setting'  => $archive . '_layout',
				'operator' => '==',
				'value'    => 'grid',
			),
		),
	) );

	// Masonry.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'toggle',
		'settings'        => $archive . '_grid_masonry',
		'label'           => __( 'Masonry Effect', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $archive . '_options',
		'default'         => 0,
		'priority'        => 130,
		'active_callback' => array(
			array(
				'setting'  => $archive . '_layout',
				'operator' => '==',
				'value'    => 'grid',
			),
		),
	) );

	// Separator.
	new \Kirki\Pro\Field\Divider(
		[
			'settings' => $archive . '_infinite_scroll_separator',
			'section'  => 'wpbf_' . $archive . '_options',
			'priority' => 140,
		]
	);

	// Infinite Scroll.
	Kirki::add_field( 'wpbf', array(
		'type'     => 'toggle',
		'settings' => $archive . '_infinite_scroll',
		'label'    => __( 'Infinite Scroll', 'wpbfpremium' ),
		'section'  => 'wpbf_' . $archive . '_options',
		'default'  => 0,
		'priority' => 150,
	) );

}

/* Fields – Typography (page) */

// Bold color.
Kirki::add_field( 'wpbf', array(
	'type'      => 'color',
	'settings'  => 'page_bold_color',
	'label'     => __( 'Bold Text Color', 'wpbfpremium' ),
	'section'   => 'wpbf_font_options',
	'priority'  => 3,
	'transport' => 'postMessage',
	'choices'   => array(
		'alpha' => true,
	),
) );

// Line height.
Kirki::add_field( 'wpbf', array(
	'type'      => 'slider',
	'settings'  => 'page_line_height',
	'label'     => __( 'Line Height', 'wpbfpremium' ),
	'section'   => 'wpbf_font_options',
	'priority'  => 4,
	'default'   => '1.7',
	'transport' => 'postMessage',
	'choices'   => array(
		'min'  => '1',
		'max'  => '5',
		'step' => '.1',
	),
) );

/* Post Layouts - Fields */

$singles = apply_filters( 'wpbf_singles', array( 'single' ) );

foreach ( $singles as $single ) {

	$priority = 200;

	// Headline.
	new \Kirki\Pro\Field\HeadlineToggle(
		[
			'settings' => $single . '_related_posts',
			'label'    => __( 'Related Posts', 'wpbfpremium' ),
			'section'  => 'wpbf_' . $single . '_options',
			'default'  => 0,
			'priority' => $priority++,
		]
	);

	// Headline.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'text',
		'settings'        => $single . '_related_posts_headline',
		'label'           => __( 'Headline', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'default'         => __( 'Related Posts', 'wpbfpremium' ),
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Layout.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'select',
		'settings'        => $single . '_related_posts_layout',
		'label'           => __( 'Layout', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'default'         => 'grid',
		'priority'        => $priority++,
		'multiple'        => 1,
		'choices'         => array(
			'grid' => __( 'Grid', 'wpbfpremium' ),
			'list' => __( 'List', 'wpbfpremium' ),
		),
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Separator.
	new \Kirki\Pro\Field\Divider(
		[
			'settings'        => $single . '_related_posts_grid_separator',
			'section'         => 'wpbf_' . $single . '_options',
			'priority'        => $priority++,
			'active_callback' => [
				[
					'setting'  => $single . '_related_posts',
					'operator' => '==',
					'value'    => true,
				],
				[
					'setting'  => $single . '_related_posts_layout',
					'operator' => '==',
					'value'    => 'grid',
				],
			],
		]
	);

	// Sortable.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'sortable',
		'settings'        => $single . '_related_posts_grid_sortable',
		'label'           => __( 'Content', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'default'         => array(
			'featured',
			'meta',
			'title',
		),
		'choices'         => array(
			'featured' => __( 'Featured Image', 'wpbfpremium' ),
			'meta'     => __( 'Meta Data', 'wpbfpremium' ),
			'title'    => __( 'Title', 'wpbfpremium' ),
		),
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => $single . '_related_posts_layout',
				'operator' => '==',
				'value'    => 'grid',
			),
		),
	) );

	// Separator.
	new \Kirki\Pro\Field\Divider(
		[
			'settings'        => $single . '_related_posts_grid_separator_2',
			'section'         => 'wpbf_' . $single . '_options',
			'priority'        => $priority++,
			'active_callback' => [
				[
					'setting'  => $single . '_related_posts',
					'operator' => '==',
					'value'    => true,
				],
				[
					'setting'  => $single . '_related_posts_layout',
					'operator' => '==',
					'value'    => 'grid',
				],
			],
		]
	);

	// Posts per row.
	Kirki::add_field( 'wpbf', array(
		'type'              => 'responsive_input',
		'settings'          => $single . '_related_posts_grid_columns',
		'label'             => __( 'Posts per Row', 'wpbfpremium' ),
		'section'           => 'wpbf_' . $single . '_options',
		'priority'          => $priority++,
		'default'           => json_encode(
			array(
				'desktop' => '3',
				'tablet'  => '2',
				'mobile'  => '1',
			)
		),
		'active_callback'   => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => $single . '_related_posts_layout',
				'operator' => '==',
				'value'    => 'grid',
			),
		),
		'sanitize_callback' => wpbf_kirki_sanitize_helper( 'absint' ),
	) );

	// Gap.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'select',
		'settings'        => $single . '_related_posts_grid_gap',
		'label'           => __( 'Grid Gap', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'default'         => 'medium',
		'priority'        => $priority++,
		'multiple'        => 1,
		'choices'         => array(
			'small'    => __( 'Small', 'wpbfpremium' ),
			'medium'   => __( 'Medium', 'wpbfpremium' ),
			'large'    => __( 'Large', 'wpbfpremium' ),
			'xlarge'   => __( 'xLarge', 'wpbfpremium' ),
			'collapse' => __( 'Collapse', 'wpbfpremium' ),
		),
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => $single . '_related_posts_layout',
				'operator' => '==',
				'value'    => 'grid',
			),
		),
	) );

	// Display Conditions headline.
	new \Kirki\Pro\Field\Headline(
		[
			'settings'        => $single . '_related_posts_display_conditions_headline',
			'section'         => 'wpbf_' . $single . '_options',
			'priority'        => $priority++,
			'label'           => esc_html__( 'Display Conditions', 'wpbfpremium' ),
			'active_callback' => [
				[
					'setting'  => $single . '_related_posts',
					'operator' => '==',
					'value'    => true,
				],
			],
		]
	);

	// Number of posts.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'number',
		'settings'        => $single . '_related_posts_showposts',
		'label'           => __( 'Number of Posts', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'default'         => 3,
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Order by.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'select',
		'settings'        => $single . '_related_posts_orderby',
		'label'           => __( 'Order by', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'default'         => 'date',
		'choices'         => array(
			'date'     => __( 'Date', 'wpbfpremium' ),
			'modified' => __( 'Last Modified', 'wpbfpremium' ),
			'title'    => __( 'Title', 'wpbfpremium' ),
			'rand'     => __( 'Random', 'wpbfpremium' ),
		),
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Order.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'select',
		'settings'        => $single . '_related_posts_order',
		'label'           => __( 'Order', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'default'         => 'DESC',
		'choices'         => array(
			'DESC' => __( 'Descending', 'wpbfpremium' ),
			'ASC'  => __( 'Ascending', 'wpbfpremium' ),
		),
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Author.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'text',
		'settings'        => $single . '_related_posts_authors',
		'label'           => __( 'Author', 'wpbfpremium' ),
		'description'     => __( "ID or comma separated list of ID's", 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Category.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'text',
		'settings'        => $single . '_related_posts_categories',
		'label'           => __( 'Category', 'wpbfpremium' ),
		'description'     => __( "ID or comma separated list of ID's", 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

	// Post Type.
	Kirki::add_field( 'wpbf', array(
		'type'            => 'text',
		'settings'        => $single . '_related_posts_post_types',
		'label'           => __( 'Post Types', 'wpbfpremium' ),
		'description'     => __( 'Post type or comma separated list of post types.', 'wpbfpremium' ),
		'section'         => 'wpbf_' . $single . '_options',
		'priority'        => $priority++,
		'active_callback' => array(
			array(
				'setting'  => $single . '_related_posts',
				'operator' => '==',
				'value'    => true,
			),
		),
	) );

}
